/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEnderShelf
extends TileBlockEntityCyclic {
    public final EnderShelfItemHandler inventory = new EnderShelfItemHandler(this);
    private final LazyOptional<EnderShelfItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    public RenderTextType renderStyle = RenderTextType.TEXT;

    public TileEnderShelf(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ENDER_SHELF.get(), pos, state);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        if (tag.m_128441_("RenderTextType")) {
            int rt = tag.m_128451_("RenderTextType");
            this.renderStyle = RenderTextType.values()[rt];
        }
        this.inventory.resetNameCache();
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("RenderTextType", this.renderStyle.ordinal());
        super.m_183515_(tag);
    }

    public void toggleShowText() {
        int ord = this.renderStyle.ordinal() + 1;
        if (ord == RenderTextType.values().length) {
            ord = 0;
        }
        this.renderStyle = RenderTextType.values()[ord];
    }

    public static enum RenderTextType {
        TEXT,
        STACK,
        NONE;

    }
}

